/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.inconn;

import com.ibm.hsc.remotesupport.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledListener;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.path.RemoteServiceCallHomePath;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public class CallBackSessionThread
extends Thread
implements InboundConnectivityConstants,
PathCancelledListener {
    private static final String TRACE_MASKT = "JRCSCSTT";
    private static final String TRACE_MASKF = "JRCSCSTF";
    private static final String TRACE_MASKD = "JRCSCSTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-CBakThrd");
    private String taskletRequestId = this.toString();
    private int taskletRequestNum = 0;
    private PanelTasklet originTasklet;
    private CecInfo consoleInfo;
    RcsPath sessionPath = null;
    private boolean success = false;
    private boolean canceled = false;
    private Object cancelLock = new Object();

    public CallBackSessionThread(PanelTasklet panelTasklet, CecInfo cecInfo) {
        super("RCS Call-Back Session Thread " + new Date());
        this.originTasklet = panelTasklet;
        this.consoleInfo = cecInfo;
        LocalizableText localizableText = new LocalizableText("Remote service VPN session");
        this.sessionPath = new RemoteServiceCallHomePath(PathPlatform.STORAGE, true, cecInfo, null);
        Trace.trace((String)TRACE_MASKT, (Object)"<> CallBackSessionThread()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Trace.trace((String)TRACE_MASKT, (Object)"-> Session beginning");
        this.updateStatus("SESSION_BEGIN", null);
        try {
            this.updateStatus("CONNECTION_WAITING", null);
            this.sessionPath.waitForAvailability();
            this.sessionPath.setCancelListener((PathCancelledListener)this);
            this.updateStatus("CONNECTION_OPENING", null);
            this.sessionPath.open();
            if (this.sessionPath.getPathIdentifier().getState() == PathState.ACTIVE) {
                this.success = true;
                this.updateStatus("CONNECTION_SUCCESS", null);
                try {
                    object = new PanelTaskletRequest();
                    object.setSource(this.getUniqueTaskletRequestId());
                    object.setData("Source", (Object)"CallBackSessionPanel");
                    object.setData("Command", (Object)"SessionOpen");
                    this.originTasklet.postRequest("CallBackSessionBean", object);
                }
                catch (TaskletException taskletException) {
                    Trace.trace((String)TRACE_MASKT, (Object)("TaskletException: " + taskletException.getMessage()));
                }
                object = this.cancelLock;
                synchronized (object) {
                    while (!this.canceled) {
                        try {
                            this.cancelLock.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            this.updateStatus("CONNECTION_FAILED", null);
            this.updateStatus("CONNECTION_CLOSING", null);
            this.sessionPath.close();
        }
        catch (InvalidStateException invalidStateException) {
            Trace.trace((String)TRACE_MASKF, (Object)"Invalid path state");
            Object[] objectArray = new Object[]{""};
            this.updateStatus("CONNECTION_FAILED", objectArray);
        }
        catch (PathCancelledException pathCancelledException) {
            Trace.trace((String)TRACE_MASKF, (Object)"Path already canceled");
            this.updateStatus("CONNECTION_CANCELED", null);
        }
        catch (PathFailedException pathFailedException) {
            Trace.trace((String)TRACE_MASKF, (Object)"Path failed");
            Object[] objectArray = new Object[]{""};
            this.updateStatus("CONNECTION_FAILED", objectArray);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)"Uncaught exception");
            Object[] objectArray = new Object[]{"(" + exception.getMessage() + ")"};
            this.updateStatus("CONNECTION_FAILED", objectArray);
            this.updateStatus("CONNECTION_CLOSING", null);
            this.sessionPath.close();
        }
        if (this.success) {
            this.updateStatus("SESSION_SUCCESS", null);
        } else {
            this.updateStatus("SESSION_FAILED", null);
        }
        try {
            object = new PanelTaskletRequest();
            object.setSource(this.getUniqueTaskletRequestId());
            object.setData("Source", (Object)"CallBackSessionPanel");
            object.setData("Command", (Object)"SessionComplete");
            this.originTasklet.postRequest("CallBackSessionBean", object);
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKT, (Object)("TaskletException: " + taskletException.getMessage()));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- Session ending");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> cancel()");
        Object object = this.cancelLock;
        synchronized (object) {
            this.canceled = true;
            this.cancelLock.notifyAll();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- cancel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathCancelled(PathCancelReason pathCancelReason) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> pathCancelled()");
        this.updateStatus("CONNECTION_CANCELED", null);
        Object object = this.cancelLock;
        synchronized (object) {
            this.canceled = true;
            this.cancelLock.notifyAll();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- pathCancelled()");
    }

    private void updateStatus(String string, Object[] objectArray) {
        LocalizableText localizableText = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string, objectArray);
        try {
            PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
            panelTaskletRequest.setSource(this.getUniqueTaskletRequestId());
            panelTaskletRequest.setData("Source", (Object)"CallBackSessionPanel");
            panelTaskletRequest.setData("Command", (Object)"UpdateStatus");
            panelTaskletRequest.setData("StatusInfo", (Object)localizableText);
            this.originTasklet.postRequest("CallBackSessionBean", panelTaskletRequest);
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKT, (Object)("TaskletException: " + taskletException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletRequestId() {
        CallBackSessionThread callBackSessionThread = this;
        synchronized (callBackSessionThread) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.taskletRequestId);
            stringBuffer.append("-");
            stringBuffer.append(++this.taskletRequestNum);
            return stringBuffer.toString();
        }
    }
}

